@php
use Illuminate\Support\Facades\App;
@endphp
<!DOCTYPE html>
<html class="no-js" lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <title>@yield('title')</title>
    <meta name="robots" content="noindex, follow" />
    <meta name="description" content="">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <!-- Favicon -->
    <link rel="shortcut icon" type="image/x-icon" href="/assets/images/wese/wese_logo.png">

    <!-- CSS
	============================================ -->

    <!-- Vendor CSS (Bootstrap & Icon Font) -->
    <!-- <link rel="stylesheet" href="/assets/css/vendor/bootstrap.min.css">
    <link rel="stylesheet" href="/assets/css/vendor/font-awesome-pro.min.css">
    <link rel="stylesheet" href="/assets/css/vendor/font-gilroy.css"> -->

    <!-- Plugins CSS (All Plugins Files) -->
    <!-- <link rel="stylesheet" href="assets/css/plugins/select2.min.css">
    <link rel="stylesheet" href="/assets/css/plugins/perfect-scrollbar.css">
    <link rel="stylesheet" href="/assets/css/plugins/swiper.min.css">
    <link rel="stylesheet" href="/assets/css/plugins/nice-select.css">
    <link rel="stylesheet" href="/assets/css/plugins/ion.rangeSlider.min.css">
    <link rel="stylesheet" href="/assets/css/plugins/photoswipe.css">
    <link rel="stylesheet" href="/assets/css/plugins/photoswipe-default-skin.css">
    <link rel="stylesheet" href="/assets/css/plugins/magnific-popup.css">
    <link rel="stylesheet" href="/assets/css/plugins/slick.css"> -->

    <!-- Main Style CSS -->
    <!-- <link rel="stylesheet" href="assets/css/style.css"> -->

    <!-- Use the minified version files listed below for better performance and remove the files listed above -->
    <link rel="stylesheet" href="/assets/css/vendor/vendor.min.css">
    <link rel="stylesheet" href="/assets/css/plugins/plugins.min.css">
    <link rel="stylesheet" href="/assets/css/style.css?v=006">
    <link rel="stylesheet" href="/assets/css/wese.css?v=006">
    
    @stack('extracss')

</head>

<body>

    <div id="page">
        <!-- Header Section Start -->
        <div class="header-section header-transparent header-sticky-bg-dark header-light sticky-header section">
            <div class="header-inner">
                <div class="container position-relative">
                    <div class="row justify-content-between align-items-center">

                        <!-- Header Logo Start -->
                        <div class="col-xl-3 col-auto">
                            <div class="header-logo">
                                <a href="/">
                                    <img class="dark-logo" src="/assets/images/wese/wese_logo.png" alt="Wese Logo" style="width:120px">
                                    <img class="light-logo" src="/assets/images/wese/wese_logo.png" alt="Wese Logo" style="width:120px">
                                </a>
                            </div>
                        </div>
                        <!-- Header Logo End -->

                        <!-- Header Right Start -->
                        <div class="col-xl-8 col-auto">
                            <div class="header-right">
                                <div class="inner">

                                    <div>
                                        <nav class="site-main-menu menu-hover-1">
                                            <ul>
                                                <li>
                                                    <a href="#"><span class="menu-text" style="font-size:24px">{{__('message.nyumbani')}}</span></a>
                                                </li>
                                                <li class="">
                                                    <a href="#dereva"><span class="menu-text" style="font-size:24px;color:#F8A517">{{__('message.dereva')}}</span></a>
                                                </li>
                                                <li class="">
                                                    <a href="#wakala"><span class="menu-text" style="font-size:24px;color:#F8A517">{{__('message.wakala_nav')}}</span></a>
                                                </li>
                                                <li class="">
                                                    <a href="/qna"><span class="menu-text" style="font-size:24px;color:#F8A517">{{__('message.maswali_na_majibu')}}</span></a>
                                                </li>
                                            </ul>
                                        </nav>
                                    </div>

                                </div>
                            </div>
                        </div>
                        <!-- Header Right End -->

                    </div>
                </div>
            </div>
        </div>
        <!-- Header Section End -->



        @yield('content')
        
        <!-- Messenger Chat Plugin Code -->
    <div id="fb-root"></div>

    <!-- Your Chat Plugin code -->
    <div id="fb-customer-chat" class="fb-customerchat">
    </div>




        <div class="footer-section section" data-bg-color="#000">
            <div class="container" style="padding:36px">

                <div class="row">
                    <div class="col-lg-6">
                        <img src="/assets/images/wese/wese_logo.png">
                    </div>
                    
                </div>

                <!-- Footer Top Widgets Start -->
                <div class="row">

                    <!-- Footer Widget Start -->
                    <div class="col-xl-4 col-md-4 max-mb-50" >
                        <div class="footer-widget light-color">
                            <h2 class="footer-widget-title" style="font-family: Roboto-Thin;font-size: 36px;">{{__('message.kuhusu')}} <span style="color:#F8A517;font-family:Roboto">{{__('message.wese')}}?</span></h2>
                            <div class="footer-widget-content">
                                <div class="content">

                                    <p style="color:#fff;font-family:Roboto-Light;font-size:16px">{{__('message.kuhusu_wese_text')}}
                                    </p>

                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Footer Widget End -->

                    <!-- Footer Widget Start -->
                    <div class="col-xl-4 col-md-4 max-mb-50">
                        <div class="footer-widget light-color">
                            <h2 class="footer-widget-title" style="font-family: Roboto-Thin;font-size: 36px;">{{__('message.wasiliana')}} <span style="color:#F8A517;font-family:Roboto">{{__('message.nasi')}}</span></h2>
                            <div class="footer-widget-content">

                                <p style="color:#fff;font-family:Roboto-Light;font-size:16px">
                                    WESE Energies Limited.
                                    <br>Mwanga Tower 13th Floor - Right Wing,
                                    <br>Kijitonyama, New Bagamoyo Road,
                                    <br>Dar es salaam, Tanzania.
                                    <br><a href="tel:+255679060044" style="color:#F8A517">+255 679 060 044</a>
                                    <br><a href="mailto:business@wese.co.tz" style="color:#F8A517">business@wese.co.tz</a>

                                </p>
                                <?php
                                /*
                                <h4 class="footer-widget-title font_24 mt-4">{{__('message.idhini')}}</h4>
                                <div class="footer-social-inline">
                                        <img src="/assets/images/wese/fcc.png" style="height:48px;">
                                        <img src="/assets/images/wese/cosota.png" style="height:48px;margin-left:12px">
                                </div>
                                */
                                ?>
                                
                            </div>
                        </div>
                    </div>
                    <!-- Footer Widget End -->

                    <!-- Footer Widget Start -->
                    <div class="col-xl-4 col-md-4 max-mb-50">
                        <div class="footer-widget light-color">
                            <h2 class="footer-widget-title" style="font-family: Roboto-Thin;font-size: 36px;">{{__('message.fahamu')}} <span style="color:#F8A517;font-family:Roboto">{{__('message.zaidi')}}</span></h2>
                            <div class="footer-widget-content">
                                <div>
                                <a href="/tnc" class="btn" style="padding: 16px;background:transparent; border:1px solid #F8A517;color: #F8A517 ; border-radius: 82px;">{{__('message.vigezo_na_masharti')}}</a>
                                <a href="/contact" class="btn" style="padding: 16px;background:transparent; border:1px solid #F8A517;color: #F8A517 ; border-radius: 82px;">{{__('message.mawasiliano')}}</a>
                                </div>
                                <div style="margin-top: 8px">
                                <a href="/qna" class="btn" style="padding: 16px;background:transparent; border:1px solid #F8A517;color: #F8A517 ; border-radius: 82px;">{{__('message.maswali_na_majibu')}}</a>
                                <a href="/privacy-policy" class="btn" style="padding: 16px;background:transparent; border:1px solid #F8A517;color: #F8A517 ; border-radius: 82px;">{{__('message.sera_ya_faragha')}}</a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Footer Widget End -->

                </div>

                <div class="row">

                    <!-- Footer Widget Start -->
                    <div class="col-xl-4 col-md-4 col-12 max-mb-50">
                        <div class="footer-widget light-color">
                            <h2 class="footer-widget-title" style="font-family: Roboto-Light;font-size: 20px;color:#696969">{{__('message.lugha')}}</h2>
                            <div class="footer-widget-content">
                                <div class="content">

                                    <a href="/lang/change/sw" class="btn btn-dark" style="background:transparent; border:1px solid #FFF;color: #FFF; border-radius: 82px;">Kiswahili</a>
                                    <a href="/lang/change/en" class="btn" style="background:transparent; border:1px solid #F8A517;color: #F8A517 ; border-radius: 82px;">English</a>

                                </div>
                                
                            </div>
                        </div>
                    </div>
                    <!-- Footer Widget End -->

                    <!-- Footer Widget Start -->
                    <div class="col-xl-4 col-md-4 col-12 max-mb-50">
                        <div class="footer-widget light-color">
                             <h2 class="footer-widget-title" style="font-family: Roboto-Light;font-size: 20px;color:#696969">{{__('message.tufuate')}}</h2>
                            <div class="footer-widget-content">
                             <div class="footer-social-inline">
                                    <a href="https://www.facebook.com/profile.php?id=100086151626606" target="_blank"><i class="fab fa-facebook-square" style="color:#fff"></i></a>
                                    <a href="https://twitter.com/Wese_tz" target="_blank"><i class="fab fa-twitter" style="color:#fff"></i></a>
                                    <a href="https://www.instagram.com/wese_tz/" target="_blank"><i class="fab fa-instagram" style="color:#fff"></i></a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Footer Widget End -->

                </div>
                <!-- Footer Top Widgets End -->

                <!-- Footer Copyright Start -->
                <div class="row max-mt-20">
                    <div class="col-11">
                        <p class="copyright " style="padding:0.5em;border-top: 1px solid #b6b6b6;padding: 16px;">&copy; 2022 WESE Energies Limited. {{__('message.haki_zote')}} </p>
                        
                    </div>
                    <div class="col-1">
                        <a href="#" class="scroll-top col-2" id="scroll-top" style="float: right;visibility: visible;opacity: 1;position: fixed;bottom: 5%;background: transparent;border: 2px solid #F8A517 ;">
                        <i class="arrow-top fal fa-long-arrow-up" style="color:#F8A517"></i>
                        <i class="arrow-bottom fal fa-long-arrow-up" style="color: #F8A517"></i>
                        </a>  
                    </div>
                </div>
                <!-- Footer Copyright End -->

            </div>
        </div>

        <!-- Scroll Top Start -->
        <a href="#" class="scroll-top" id="scroll-top">
            <i class="arrow-top fal fa-long-arrow-up"></i>
            <i class="arrow-bottom fal fa-long-arrow-up"></i>
        </a>
        <!-- Scroll Top End -->
        
    </div>

			    <!-- JS
			============================================ -->

			    <!-- Vendors JS -->
			    <!-- <script src="assets/js/vendor/modernizr-3.6.0.min.js"></script>
			<script src="assets/js/vendor/jquery-3.6.0.min.js"></script>
			<script src="assets/js/vendor/jquery-migrate-3.3.2.min.js"></script>
			<script src="assets/js/vendor/bootstrap.bundle.min.js"></script> -->

			    <!-- Plugins JS -->
			    <!-- <script src="assets/js/plugins/parallax.min.js"></script>
			<script src="assets/js/plugins/jquery.ajaxchimp.min.js"></script> -->

	    <script src="/assets/js/vendor/vendor.min.js"></script>
	    <script src="/assets/js/plugins/plugins.min.js"></script>

    <!-- Main Activation JS -->
    <script src="/assets/js/main.js"></script>
    
    @stack('extrajs')
    
    <script>
      var chatbox = document.getElementById('fb-customer-chat');
      chatbox.setAttribute("page_id", "100873462811078");
      chatbox.setAttribute("attribution", "biz_inbox");
    </script>

    <!--  SDK code -->
    <script>
      window.fbAsyncInit = function() {
        FB.init({
          xfbml            : true,
          version          : 'v15.0'
        });
      };

      (function(d, s, id) {
        var js, fjs = d.getElementsByTagName(s)[0];
        if (d.getElementById(id)) return;
        js = d.createElement(s); js.id = id;
        js.src = 'https://connect.facebook.net/en_US/sdk/xfbml.customerchat.js';
        fjs.parentNode.insertBefore(js, fjs);
      }(document, 'script', 'facebook-jssdk'));
    </script>




</body>

</html>